/*
 * Author: Gagan B., Ajit D.
 * Date: 11-NOV-2025
 * Purpose: Logic for activities to be done Post Manage SQL Transaction
 * */

package ibase.webitm.ejb.sys;

import java.rmi.RemoteException;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

import javax.naming.InitialContext;

import org.w3c.dom.Document;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class ManageSQLAprv extends ValidatorEJB{
	
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String updateWFStatus()throws RemoteException,ITMException
	{
		return "";
	}
	
	public String updateWFStatus(String domString, Connection conn) throws RemoteException,ITMException
	{
		String retVal = "";
		String refSer = "";
		String tranID = "";
		String signStatus = "";
		String enterprises1 = "";
		boolean isLocalConn = false;
		PreparedStatement mSqlPstmt = null;
		ResultSet mSqlRs = null;
		PreparedStatement mSqlDetPstmt = null;
		ResultSet mSqlDetRs = null;
		String empCode = "";
		String entityCode = "",reportTo="",allocatedTo;
		LocalDate tranDate = LocalDate.now();// for tranDate
		LocalTime tranTime = LocalTime.now();
		String tranDateStr = formatDateTime(tranDate, tranTime);
		String tranId = "";
		String reqId = "";
		String custCode = "";
		String empCodeGiven = "";
		String empCodeMerge = "";
		String executed = "";
		String tranIdOrg = "";
		String activeYn = "";
		String itmVer = "";
		String chgUser = "";
		String chgTerm = "";
		String confirmed = "";
		String empCodeAprv = "";
		String enterprises = "";
		String applDb = "";
		String execRights = "";
		String tranIdRef = "";
		
		String db2Statement = "";
		String lineNo = "";
		String oracleStatement = "";
		String statementType = "";
		//InitialContext ctx = null;
		String retString = null;
		String executionRights = "";
//		MasterStatefulLocal masterStateful = null; // for ejb3
		
		try
		{
		    UserInfoBean userInfo = new UserInfoBean(); 
            CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
			//AppConnectParm appConnect = new AppConnectParm();
			//ctx = new InitialContext(appConnect.getProperty());
//			masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
			
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext initialContext = new InitialContext(appConnect.getProperty());
			
			System.out.println("ManageSQLAprv.updateWFStatus() domString testtttttttt["+domString+"]");
			if (conn == null)
			{
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(userInfo.getTransDB());
			}

			Document dom = genericUtility.parseString(domString);

			refSer = genericUtility.getColumnValue("ref_ser",dom,"1");
			tranID = genericUtility.getColumnValue("ref_id",dom,"1");
			signStatus = genericUtility.getColumnValue("sign_status",dom,"1");
			empCode = genericUtility.getColumnValue("emp_code",dom,"1");
			allocatedTo = genericUtility.getColumnValue("allocated_to",dom,"1");
			System.out.println("enterprises::::: =[" + enterprises1 + "]"+"  tran_id::"+tranID);
			userInfo = commonDBAccessEJB.createUserInfo(empCode);
			System.out.println("enterprises::::: =[" + enterprises1 + "]"+"  tran_id::"+tranID+" empCode::"+empCode);

			String msqlDetSql = "SELECT TRAN_ID, TRAN_DATE, REQ_ID, REQ_DATE, CUST_CODE, EMP_CODE__GIVEN, EMP_CODE__MERGE, "
			        + "EXECUTED, TRAN_ID__ORG, ACTIVE_YN, ITM_VER, CHG_USER, CHG_TERM, CHG_DATE, CONFIRMED, CONF_DATE, "
			        + "EMP_CODE_APRV, ENTERPRISES, APPL_DB, EXEC_RIGHTS, TRAN_ID__REF "
			        + "FROM sql_changes where tran_id = ?";

			 mSqlPstmt = conn.prepareStatement(msqlDetSql);
			 mSqlPstmt.setString(1, tranID);
			 mSqlRs = mSqlPstmt.executeQuery();

			while (mSqlRs.next()) {
			    // Directly fetching and using values from result set without declaring variables
			     tranId = mSqlRs.getString("TRAN_ID");
			     reqId = mSqlRs.getString("REQ_ID");
			     custCode = mSqlRs.getString("CUST_CODE");
			     empCodeGiven = mSqlRs.getString("EMP_CODE__GIVEN");
			     empCodeMerge = mSqlRs.getString("EMP_CODE__MERGE");
			     executed = mSqlRs.getString("EXECUTED");
			     tranIdOrg = mSqlRs.getString("TRAN_ID__ORG");
			     activeYn = mSqlRs.getString("ACTIVE_YN");
			     itmVer = mSqlRs.getString("ITM_VER");
			     chgUser = mSqlRs.getString("CHG_USER");
			     chgTerm = mSqlRs.getString("CHG_TERM");
			     confirmed = mSqlRs.getString("CONFIRMED");
			     empCodeAprv = mSqlRs.getString("EMP_CODE_APRV");
			     enterprises = mSqlRs.getString("ENTERPRISES");
			     applDb = mSqlRs.getString("APPL_DB");
			     execRights = mSqlRs.getString("EXEC_RIGHTS");
			     tranIdRef = mSqlRs.getString("TRAN_ID__REF");

			    // Do something with these values directly (e.g., use them in logic, or store in a collection)
			    
			    System.out.println("TRAN_ID: " + tranId + ", " +
	                       "TRAN_DATE: " + tranDate + ", " +
	                       "REQ_ID: " + reqId + ", " +
	                       "CUST_CODE: " + custCode + ", " +
	                       "EMP_CODE__GIVEN: " + empCodeGiven + ", " +
	                       "EMP_CODE__MERGE: " + empCodeMerge + ", " +
	                       "EXECUTED: " + executed + ", " +
	                       "TRAN_ID__ORG: " + tranIdOrg + ", " +
	                       "ACTIVE_YN: " + activeYn + ", " +
	                       "ITM_VER: " + itmVer + ", " +
	                       "CHG_USER: " + chgUser + ", " +
	                       "CHG_TERM: " + chgTerm + ", " +
	                       "CONFIRMED: " + confirmed + ", " +
	                       "EMP_CODE_APRV: " + empCodeAprv + ", " +
	                       "ENTERPRISES: " + enterprises + ", " +
	                       "APPL_DB: " + applDb + ", " +
	                       "EXEC_RIGHTS: " + execRights + ", " +
	                       "TRAN_ID__REF: " + tranIdRef);
			}
			
			
			
			
			
			StringBuffer processDynXmlString = new StringBuffer();

			// Start building the XML string
			processDynXmlString.append("<DocumentRoot><description>Datawindow Root</description><group0>");
			processDynXmlString.append(
					"<description>Group0 description</description><Header0><description>Header0 members</description>");
			processDynXmlString.append("<objName><![CDATA[sql_changes]]></objName>");
			processDynXmlString.append("<pageContext><![CDATA[1]]></pageContext>");
			processDynXmlString.append("<objContext><![CDATA[1]]></objContext>");
			processDynXmlString.append("<editFlag><![CDATA[A]]></editFlag>");
			processDynXmlString.append("<focusedColumn><![CDATA[]]></focusedColumn>");
			processDynXmlString.append("<action><![CDATA[SAVE]]></action>");
			processDynXmlString.append("<elementName><![CDATA[]]></elementName>");
			processDynXmlString.append("<keyValue><![CDATA[1]]></keyValue>");
			processDynXmlString.append("<saveLevel><![CDATA[1]]></saveLevel>");
			processDynXmlString.append("<forcedSave><![CDATA[false]]></forcedSave>");
			processDynXmlString.append("<Detail1 dbID='' domID='1'  objContext='1'  objName='sql_changes'>");
			processDynXmlString
					.append("<attribute IS_CHANGE='Y' pkNames='TRAN_ID' selected='N' status='N' updateFlag='A'/>");
			
			
			//processDynXmlString.append("<tran_id/>");
			processDynXmlString.append("<tran_date><![CDATA[" + dateFormatter(tranDateStr) + "]]></tran_date>");
			processDynXmlString.append("<req_id><![CDATA[]]></req_id>");
			processDynXmlString.append("<req_date><![CDATA[" + dateFormatter(tranDateStr) + "]]></req_date>");
			processDynXmlString.append("<emp_code__given><![CDATA[" + empCodeGiven + "]]></emp_code__given>");
			processDynXmlString.append("<emp_code__merge><![CDATA[" + empCodeMerge + "]]></emp_code__merge>");
			processDynXmlString.append("<executed><![CDATA[N]]></executed>");
			processDynXmlString.append("<tran_id__org><![CDATA[" + tranIdOrg + "]]></tran_id__org>");
			processDynXmlString.append("<active_yn><![CDATA[" + activeYn + "]]></active_yn>");
			processDynXmlString.append("<chg_user><![CDATA[" + chgUser + "]]></chg_user>");
			processDynXmlString.append("<chg_term><![CDATA[" + chgTerm + "]]></chg_term>");
			processDynXmlString.append("<confirmed><![CDATA[N]]></confirmed>");
			processDynXmlString.append("<conf_date><![CDATA[]]></conf_date>");
			processDynXmlString.append("<itm_ver><![CDATA[]]></itm_ver>");
			processDynXmlString.append("<enterprises><![CDATA[{{enterprises}}]]></enterprises>");
			processDynXmlString.append("<emp_code_aprv><![CDATA[]]></emp_code_aprv>");
			processDynXmlString.append("<chg_date><![CDATA[" + dateFormatter(tranDateStr) + "]]></chg_date>");
			processDynXmlString.append("<appl_db><![CDATA[" + applDb + "]]></appl_db>");
			processDynXmlString.append("<exec_rights><![CDATA[{{executionRights}}]]></exec_rights>");
			processDynXmlString.append("<tran_id__ref><![CDATA[" + tranId + "]]></tran_id__ref>");
			processDynXmlString.append("</Detail1>");

			String msqlDet1Sql = "SELECT LINE_NO, ORA_STMNT, DB2_STMNT, STMNT_TYPE FROM sql_changes_det WHERE tran_id = ?";
			mSqlDetPstmt = conn.prepareStatement(msqlDet1Sql);
			mSqlDetPstmt.setString(1, tranID);
			mSqlDetRs = mSqlDetPstmt.executeQuery();

			while (mSqlDetRs.next()) {
			     lineNo = checkNull(mSqlDetRs.getString("LINE_NO"));
			     oracleStatement = checkNull(mSqlDetRs.getString("ORA_STMNT"));
			     db2Statement = checkNull(mSqlDetRs.getString("DB2_STMNT"));
			     statementType = checkNull(mSqlDetRs.getString("STMNT_TYPE"));

			    processDynXmlString.append("<Detail2 dbID=':' domID='2' objName=\"sql_changes\" objContext=\"2\">");
			    processDynXmlString.append("<attribute pkNames=\"\" selected=\"N\" updateFlag=\"A\" status=\"N\" />");
			    processDynXmlString.append("<line_no><![CDATA[").append(lineNo).append("]]></line_no>");
			    processDynXmlString.append("<ora_stmnt><![CDATA[").append(oracleStatement).append("]]></ora_stmnt>");
			    processDynXmlString.append("<db2_stmnt><![CDATA[").append(db2Statement).append("]]></db2_stmnt>");
			    processDynXmlString.append("<stmnt_type><![CDATA[").append(statementType).append("]]></stmnt_type>");
			    processDynXmlString.append("</Detail2>");
			}

			if (mSqlDetRs != null) {
			    mSqlDetRs.close();
			    mSqlDetRs = null;
			}
			if (mSqlDetPstmt != null) {
			    mSqlDetPstmt.close();
			    mSqlDetPstmt = null;
			}

			processDynXmlString.append("</Header0></group0></DocumentRoot>");

			// Now, processDynXmlString contains the dynamically generated XML with the values from your query
			System.out.println(processDynXmlString.toString());
//			String  tranIDNew = commonDBAccessEJB.generateSeq("asset_assign_seq", 10, userInfo.getTransDB());
//		    BaseLogger.log("3", null, null, " generated tranID :: " + tranIDNew); // tran_id
//			processDynXmlString.toString().replace("{{tranId}}", tranIdNew);
			String xmlWithQ = processDynXmlString.toString().replace("{{executionRights}}", "Q");
			xmlWithQ = xmlWithQ.toString().replace("{{enterprises}}", "APPVISQC");
        	BaseLogger.log("3", null, null, "xmlWithQ XML:::" +  xmlWithQ + "]");
			String xmlWithD = processDynXmlString.toString().replace("{{executionRights}}", "D");
			xmlWithD = xmlWithD.toString().replace("{{enterprises}}", "APPVISDEV");
        	BaseLogger.log("3", null, null, "userInfo::" +  userInfo.toString() + "]");
        	
        	MasterStatefulLocal masterStateful = (MasterStatefulLocal) initialContext
					.lookup("ibase/MasterStatefulEJB/local"); 
        	
            String processRequestResultDev = masterStateful.processRequest(userInfo, xmlWithD, false, conn);
        	BaseLogger.log("3", null, null, "processRequest processRequestResultD" +  processRequestResultDev + "]");
        	
        	masterStateful = null;
        	appConnect = null;
        	initialContext = null;
        	
        	appConnect = new AppConnectParm();
			initialContext = new InitialContext(appConnect.getProperty());
        	masterStateful = (MasterStatefulLocal) initialContext
					.lookup("ibase/MasterStatefulEJB/local"); 
        	
        	String processRequestResultQC = masterStateful.processRequest(userInfo, xmlWithQ, false, conn);
        	BaseLogger.log("3", null, null, "processRequest gsbnice processRequestResultQ" +  processRequestResultQC + "]");
        	
        	retString = processRequestResultQC;
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					if ( isLocalConn )
					{
						conn.close();
						conn = null;
					}
				}
            }
			catch(Exception e)
			{
			}
		}
		return retString;
	}
	 public static String formatDateTime(LocalDate tranDate, LocalTime tranTime) {
			LocalDateTime tranDateTime = LocalDateTime.of(tranDate, tranTime);
			DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
			String formattedDateTime = tranDateTime.format(formatter);
			return formattedDateTime;
		}
	 
	    public static String dateFormatter(String inputDateString ) {
			String result = "";
	        String inputFormat = "yyyy-MM-dd HH:mm:ss";
	        String outputFormat = "dd/MM/yy HH:mm:ss";

	        try {
	            // Parse input date string
	            SimpleDateFormat inputFormatter = new SimpleDateFormat(inputFormat);
	            Date date = inputFormatter.parse(inputDateString);

	            // Format the date in the desired output format
	            SimpleDateFormat outputFormatter = new SimpleDateFormat(outputFormat);
	            String outputDateString = outputFormatter.format(date);

	            System.out.println("Input Date: " + inputDateString);
	            System.out.println("Formatted Date: " + outputDateString);
	            result = outputDateString;

	        } catch (Exception e) {
	        	BaseLogger.log("3", null, null, "Exception in dateFormatter. [" +  E12GenericUtility.getStackTrace(e) + "]");
	        }
	        return result;
		}
	    
	    private void closeResources(ResultSet rs, PreparedStatement pstmt, Connection conn) {
			if (rs != null) {
				try {
					rs.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
			if (pstmt != null) {
				try {
					pstmt.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
			if (conn != null) {
				try {
					conn.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}
	    
		private String checkNull(String input)
		{
			if(input == null)
			{
				input = "";
			}
			return input;
		}

}